function submitForm(){
    let name = document.getElementById("name").value.trim();
    let email = document.getElementById("email").value.trim();
    let phone = document.getElementById("phone").value.trim();
    let message = document.getElementById("message").value.trim();

    let errors = {};

    // Client-side validation
    if(!name) errors.name = "Name required";
    if(!email.includes("@")) errors.email = "Email invalid";
    if(phone.length !== 10) errors.phone = "Phone must be 10 digits";
    if(message.length < 10) errors.message = "Message too short";

    document.querySelectorAll(".text-danger").forEach(e=>e.innerText="");

    if(Object.keys(errors).length > 0){
        for(let k in errors){
            document.getElementById(k+"_error").innerText = errors[k];
        }
        return;
    }

    let fd = new FormData();
    fd.append("name",name);
    fd.append("email",email);
    fd.append("phone",phone);
    fd.append("message",message);

    fetch("ajax/submit.php",{
        method:"POST",
        body:fd
    })
    .then(r=>r.json())
    .then(res=>{
        if(res.status){
            alert(res.message);
            document.getElementById("contactForm").reset();
        } else {
            for(let k in res.errors){
                document.getElementById(k+"_error").innerText = res.errors[k];
            }
        }
    });
}
