<?php
require_once "../config/db.php";

$action = $_POST['action'] ?? '';

if($action === "register"){
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    if(!$name || !$email || !$password){
        echo json_encode(["status"=>false,"message"=>"All fields required"]); exit;
    }

    if(!filter_var($email,FILTER_VALIDATE_EMAIL)){
        echo json_encode(["status"=>false,"message"=>"Invalid email"]); exit;
    }

    $hash = password_hash($password,PASSWORD_DEFAULT);

    try{
        $stmt = $pdo->prepare("INSERT INTO users (name,email,password) VALUES (?,?,?)");
        $stmt->execute([$name,$email,$hash]);
        echo json_encode(["status"=>true,"message"=>"Registered successfully"]);
    } catch(PDOException $e){
        echo json_encode(["status"=>false,"message"=>"Email already exists"]);
    }
    exit;
}

if($action === "login"){
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email=?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if($user && password_verify($password,$user['password'])){
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['name'];
        echo json_encode(["status"=>true,"message"=>"Login success"]);
    } else {
        echo json_encode(["status"=>false,"message"=>"Invalid credentials"]);
    }
    exit;
}

if($action === "logout"){
    session_destroy();
    echo json_encode(["status"=>true]);
}
