<!DOCTYPE html>
<html>
<head>
<title>Pagination + Search</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
<h4>User List</h4>

<input id="search" class="form-control mb-2" placeholder="Search..." onkeyup="load(1)">

<table class="table table-bordered">
<thead><tr><th>ID</th><th>Name</th><th>Email</th></tr></thead>
<tbody id="rows"></tbody>
</table>

<div id="pagination"></div>
</div>

<script>
function load(page=1){
 let fd=new FormData();
 fd.append("page",page);
 fd.append("search",search.value);

 fetch("ajax/fetch.php",{method:"POST",body:fd})
 .then(r=>r.json())
 .then(res=>{
  rows.innerHTML="";
  res.data.forEach(r=>{
   rows.innerHTML+=`<tr><td>${r.id}</td><td>${r.name}</td><td>${r.email}</td></tr>`;
  });

  let pages=Math.ceil(res.total/res.limit);
  pagination.innerHTML="";
  for(let i=1;i<=pages;i++){
   pagination.innerHTML+=`<button class='btn btn-sm btn-outline-primary me-1' onclick='load(${i})'>${i}</button>`;
  }
 });
}
load();
</script>

</body>
</html>