<?php
require_once "../config/db.php";

$method = $_SERVER['REQUEST_METHOD'];

switch($method){

 case "GET":
  $stmt = $pdo->query("SELECT * FROM users");
  echo json_encode($stmt->fetchAll());
 break;

 case "POST":
  $data = json_decode(file_get_contents("php://input"),true);
  $stmt = $pdo->prepare("INSERT INTO users(name,email) VALUES(?,?)");
  $stmt->execute([$data['name'],$data['email']]);
  echo json_encode(["status"=>"User created"]);
 break;

 case "PUT":
  parse_str(file_get_contents("php://input"),$data);
  $stmt = $pdo->prepare("UPDATE users SET name=?, email=? WHERE id=?");
  $stmt->execute([$data['name'],$data['email'],$data['id']]);
  echo json_encode(["status"=>"User updated"]);
 break;

 case "DELETE":
  parse_str(file_get_contents("php://input"),$data);
  $stmt = $pdo->prepare("DELETE FROM users WHERE id=?");
  $stmt->execute([$data['id']]);
  echo json_encode(["status"=>"User deleted"]);
 break;

 default:
  http_response_code(405);
  echo json_encode(["error"=>"Method not allowed"]);
}
