
<?php
require "config.php";
if ($_SESSION['role'] !== 'admin') die("Access denied");

$students = $pdo->query("SELECT * FROM students ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
<title>Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-dark bg-dark px-3">
<span class="navbar-brand">Admin Panel</span>
<a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
</nav>

<div class="container mt-4">
<div class="card shadow p-3 mb-4">
<h5>Add Student</h5>
<form method="post" action="save_student.php" enctype="multipart/form-data">
<div class="row">
<div class="col-md-4 mb-2"><input name="name" class="form-control" placeholder="Name" required></div>
<div class="col-md-4 mb-2"><input name="email" class="form-control" placeholder="Email" required></div>
<div class="col-md-4 mb-2"><input name="phone" class="form-control" placeholder="Phone" required></div>
<div class="col-md-4 mb-2"><input type="date" name="dob" class="form-control" required></div>
<div class="col-md-4 mb-2"><input type="file" name="image" class="form-control" required></div>
</div>
<button class="btn btn-success">Add</button>
</form>
</div>

<table class="table table-bordered table-striped shadow">
<tr>
<th>Name</th><th>Email</th><th>Phone</th><th>DOB</th><th>Image</th><th>Action</th>
</tr>
<?php foreach($students as $s): ?>
<tr>
<td><?=htmlspecialchars($s['name'])?></td>
<td><?=htmlspecialchars($s['email'])?></td>
<td><?=htmlspecialchars($s['phone'])?></td>
<td><?=$s['dob']?></td>
<td><img src="uploads/<?=$s['image']?>" width="50"></td>
<td>
<a href="edit.php?id=<?=$s['id']?>" class="btn btn-warning btn-sm">Edit</a>
<a href="delete.php?id=<?=$s['id']?>" class="btn btn-danger btn-sm"
onclick="return confirm('Delete?')">Delete</a>
</td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body>
</html>
