<?php
$secret = "MY_SECRET_KEY_123";

function base64url($data){
 return rtrim(strtr(base64_encode($data),'+/','-_'),'=');
}

function generateJWT($payload){
 global $secret;
 $header = base64url(json_encode(["alg"=>"HS256","typ"=>"JWT"]));
 $body = base64url(json_encode($payload));
 $signature = base64url(hash_hmac("sha256","$header.$body",$secret,true));
 return "$header.$body.$signature";
}

function verifyJWT($jwt){
 global $secret;
 [$h,$b,$s] = explode(".",$jwt);
 $check = base64url(hash_hmac("sha256","$h.$b",$secret,true));
 return hash_equals($check,$s) ? json_decode(base64_decode($b),true) : false;
}
