<!DOCTYPE html>
<html>
<head>
<title>Student CRUD</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-4">
<div class="card p-3 shadow">
<h4>Add Student</h4>

<form id="studentForm" enctype="multipart/form-data">
<input class="form-control mb-2" name="name" placeholder="Name">
<input class="form-control mb-2" name="email" placeholder="Email">
<input class="form-control mb-2" name="mobile" placeholder="Mobile">
<input type="date" class="form-control mb-2" name="dob">
<select class="form-control mb-2" name="gender">
<option value="">Gender</option>
<option>Male</option>
<option>Female</option>
</select>
<input type="file" class="form-control mb-2" name="image">
<button class="btn btn-dark">Save</button>
</form>

<hr>
<table class="table table-bordered mt-3">
<thead><tr><th>Name</th><th>Email</th><th>Action</th></tr></thead>
<tbody id="list"></tbody>
</table>
</div>
</div>

<script>
const form=document.getElementById("studentForm");
form.onsubmit=e=>{
 e.preventDefault();
 let fd=new FormData(form);
 fetch("ajax/save.php",{method:"POST",body:fd})
 .then(r=>r.json()).then(res=>{
  if(res.status){ form.reset(); load(); }
  else alert(res.msg);
 });
};

function load(){
 fetch("ajax/fetch.php")
 .then(r=>r.json())
 .then(data=>{
  list.innerHTML="";
  data.forEach(s=>{
   list.innerHTML+=`<tr>
    <td>${s.name}</td>
    <td>${s.email}</td>
    <td><button onclick="del(${s.id})" class="btn btn-sm btn-danger">Delete</button></td>
   </tr>`;
  });
 });
}

function del(id){
 fetch("ajax/delete.php",{method:"POST",headers:{'Content-Type':'application/x-www-form-urlencoded'},body:"id="+id})
 .then(()=>load());
}

load();
</script>
</body>
</html>
